% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocd.R
\name{new_XS}
\alias{new_XS}
\title{constructor of subclass 'XS' in class 'ChangepointDetector'}
\usage{
new_XS(dim, thresh, p0, w)
}
\arguments{
\item{dim}{Data dimension, all new data must be of this dimension}

\item{thresh}{Detection threshold. A positive real number.}

\item{p0}{A sparsity parameter between 0 and 1. It is the assumed fraction of
nonzero coordinates of change. Default to \code{1/sqrt(dim)}.}

\item{w}{Window size parameter.
Number of most recent data points to keep track in memory. Default is 200.}
}
\value{
An object of S3 subclass 'XS' in class 'ChangepointDetector'.
}
\description{
constructor of subclass 'XS' in class 'ChangepointDetector'
}
\details{
It is preferred to use \code{\link{ChangepointDetector}} for
construction.
}
\examples{
detector <- new_XS(dim=100, thresh=55.1, p0=0.1, w=200)
}
\references{
Xie, Y. and Siegmund, D. (2013) Sequential multi-sensor change-point
detection.  \emph{Ann. Statist.}, \strong{41}, 670--692.
}
