% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_fine-tuning.R
\name{fine_tuning_jobs_list_request}
\alias{fine_tuning_jobs_list_request}
\title{API fine-tuning: list jobs request}
\usage{
fine_tuning_jobs_list_request(api_key, after = NULL, limit = NULL)
}
\arguments{
\item{api_key}{string, OpenAI API key
(see https://platform.openai.com/account/api-keys)}

\item{after}{NULL/string, identifier for the last job from the previous pagination request}

\item{limit}{NULL/integer, number of fine-tuning jobs to retrieve (default 20)}
}
\value{
\link[httr]{content} of the httr \link[httr]{response} object
or SimpleError (\link[base]{conditions}) enhanced with
two additional fields: `status_code` (response$status_code)
and `message_long` (built on response content)
}
\description{
List your organization's fine-tuning jobs. To get more details, visit
https://platform.openai.com/docs/guides/fine-tuning
https://platform.openai.com/docs/api-reference/fine-tuning/list
}
\examples{
\dontrun{
res_content <- fine_tuning_jobs_list_request("my-secret-api-key-string")
if (!is_error(res_content)) {
  fine_tuning_jobs_df <- fine_tuning_fetch_jobs_list(res_content)
  print(fine_tuning_jobs_df)
}
}

}
