% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_identifiers.R
\name{list_identifiers}
\alias{list_identifiers}
\title{List OAI-PMH identifiers}
\usage{
list_identifiers(url = "http://oai.datacite.org/oai", prefix = "oai_dc",
  from = NULL, until = NULL, set = NULL, token = NULL, as = "df", ...)
}
\arguments{
\item{url}{(character) OAI-PMH base url}

\item{prefix}{Specifies the metadata format that the records will be
returned in.}

\item{from}{specifies that records returned must have been created/update/deleted
on or after this date.}

\item{until}{specifies that records returned must have been created/update/deleted
on or before this date.}

\item{set}{specifies the set that returned records must belong to.}

\item{token}{a token previously provided by the server to resume a request
where it last left off.}

\item{as}{(character) What to return. One of "df" (for data.frame; default),
"list", or "raw" (raw text)}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
List OAI-PMH identifiers
}
\examples{
\dontrun{
# from
today <- format(Sys.Date(), "\%Y-\%m-\%d")
list_identifiers(from = today)

# from and until
list_identifiers(from = '2011-06-01T', until = '2011-07-01T')

# longer time span
list_identifiers(from = '2011-06-01T', until = '2011-09-01T')

# set parameter - here, using ANDS - Australian National Data Service
list_identifiers(from = '2011-09-01T', until = '2012-09-01T', set = "ANDS")

# Get a list
list_identifiers(from = today, as = "list")

# Get raw text
list_identifiers(from = today, as = "raw")
}
}

