% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/praatScriptFormants.R
\name{praatScriptFormants}
\alias{praatScriptFormants}
\title{Generates a script for extracting formants, for use with \link{processWithPraat}.}
\usage{
praatScriptFormants(
  formants = c(1, 2),
  sample.points = c(0.5),
  time.step = 0,
  max.number.formants = 5,
  max.formant = 5500,
  max.formant.male = 5000,
  gender.attribute = "participant_gender",
  value.for.male = "M",
  window.length = 0.025,
  preemphasis.from = 50
)
}
\arguments{
\item{formants}{A vector of integers specifying which formants to extract, e.g c(1,2)
for the first and second formant.}

\item{sample.points}{A vector of numbers (0 <= sample.points <= 1) specifying multiple
points at which to take the measurement.  The default is a single point at 0.5 -
this means one measurement will be taken halfway through the target interval.  If,
for example, you wanted eleven measurements evenly spaced throughout the interval,
you would specify sample.points as being
c(0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0).}

\item{time.step}{Time step in seconds, or 0.0 for 'auto'.}

\item{max.number.formants}{Maximum number of formants.}

\item{max.formant}{Maximum formant value (Hz) for all speakers, or for female speakers,
if max.formant.male is also specified.}

\item{max.formant.male}{Maximum formant value (Hz) for male speakers, or NULL to use
the same value as max.formant.}

\item{gender.attribute}{Name of the LaBB-CAT participant attribute that contains the
participant's gender - normally this is "participant_gender".}

\item{value.for.male}{The value that the gender.attribute has when the participant is male.}

\item{window.length}{Window length in seconds.}

\item{preemphasis.from}{Pre-emphasis from (Hz)}
}
\value{
A script fragment which can be passed as the praat.script parameter of
    \link{processWithPraat}
}
\description{
This function generates a Praat script fragment which can be passed as the praat.script
parameter of \link{processWithPraat}, in order to extract selected formants.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## Get all tokens of the KIT vowel
results <- getMatches(labbcat.url, list(segments="I"))

## Get the first 3 formants at three points during the vowel
formants <- processWithPraat(
              labbcat.url,
              results$MatchId, results$Target.segments.start, results$Target.segments.end,
              window.offset=0.5,
              praatScriptFormants(formants=c(1,2,3),
              sample.points=c(0.25,0.5,0.75)))
}
}
\seealso{
\link{processWithPraat}

\link{praatScriptCentreOfGravity}

\link{praatScriptIntensity}

\link{praatScriptPitch}
}
\keyword{praat}
