% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npsp-package.R
\docType{data}
\name{aquifer}
\alias{aquifer}
\title{Wolfcamp aquifer data}
\format{A data frame with 85 observations on the following 3 variables:
\describe{
  \item{lon}{relative longitude position (miles).}
  \item{lat}{relative latitude position (miles).}
  \item{head}{piezometric-head levels (feet above sea level).}
}}
\source{
Harper, W.V. and Furr, J.M. (1986) Geostatistical analysis of
potentiometric data in the Wolfcamp Aquifer of the Palo Duro Basin, Texas.
\emph{Technical Report BMI/ONWI-587}, Bettelle Memorial Institute, Columbus, OH.
}
\description{
The Deaf Smith County (Texas, bordering New Mexico) was selected as an alternate
site for a possible nuclear waste disposal repository in the 1980s.
This site was later dropped on grounds of contamination of the aquifer,
the source of much of the water supply for west Texas.
In a study conducted by the U.S. Department of Energy, piezometric-head data
were obtained at 85 locations (irregularly scattered over the Texas panhandle)
by drilling a narrow pipe through the aquifer.

This data set has been used in numerous papers.
For instance, Cressie (1989) lists the data and uses it to illustrate kriging,
and Cressie (1993, section 4.1) gives a detailed description of the data
and results of different geostatistical analyses.
}
\examples{
str(aquifer)
summary(aquifer)
with(aquifer, spoints(lon, lat, head, main = "Wolfcamp aquifer"))
}
\references{
Cressie, N. (1989) Geostatistics. 
  \emph{The American Statistician}, \bold{43}, 197-202. 

Cressie, N. (1993) \emph{Statistics for Spatial Data}. New York. Wiley.
}
\keyword{datasets}

