% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkChangedColsLst.R
\name{checkChangedColsLst}
\alias{checkChangedColsLst}
\title{checkChangedColsLst examines list for non-empty fields}
\usage{
checkChangedColsLst(changedCols)
}
\arguments{
\item{changedCols}{list with fields for each type of column change
\code{qcStudbook}.}
}
\value{
Returns \code{NULL} if all fields are empty
else the entire list is returned.
}
\description{
checkChangedColsLst examines list for non-empty fields
}
\examples{
\donttest{
library(nprcgenekeepr)
library(lubridate)
pedOne <- data.frame(ego_id = c("s1", "d1", "s2", "d2", "o1", "o2", "o3",
                                "o4"),
                    `si re` = c(NA, NA, NA, NA, "s1", "s1", "s2", "s2"),
                    dam_id = c(NA, NA, NA, NA, "d1", "d2", "d2", "d2"),
                     sex = c("F", "M", "M", "F", "F", "F", "F", "M"),
                     birth_date = mdy(
                       paste0(sample(1:12, 8, replace = TRUE), "-",
                              sample(1:28, 8, replace = TRUE), "-",
                              sample(seq(0, 15, by = 3), 8, replace = TRUE) +
                                2000)),
                     stringsAsFactors = FALSE, check.names = FALSE)

errorLst <- qcStudbook(pedOne, reportErrors = TRUE, reportChanges = TRUE)
checkChangedColsLst(errorLst$changedCols)
}
}
