% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrumarVintage.R
\name{arrumarVintage}
\alias{arrumarVintage}
\title{Balanced pannel}
\usage{
arrumarVintage(base = NULL, legenda = NULL)
}
\arguments{
\item{base}{A time series matrix (mts) representing the vintage of interest.}

\item{legenda}{\code{data.frame} or \code{vector}. A \code{data.frame} with two columns, the first one is the name, and the second is the transformation to let the series become stationary.
A \code{vector} where each coordinate is the transformation of the correspondent coordinate in the \code{mts} of the previous argument. 
The transformation is specified as follow:
# trans 0, the original serie is preserved.
# trans 1 \deqn{latex1}{100*\frac{X_t - X_{t-1}}{X_{t-1}}} 
# trans 2 \deqn{latex2}{X_t - X_{t-1}}
# trans 3 \deqn{latex3}{100*\frac{X_t - X_{t-12}}{X_{t-12}}  -  100*\frac{X_{t-1} - X_{t-13}}{X_{t-13}}}}
}
\description{
This function transforms the original time series to its stationary representation following
the user specification. The monthly variables are agregated to represent quarterly quantities.
The time series with more than 1/3 missings, i.e. \code{NA}s are deleted.
In the end the missings and outliers are corrected.
}
