% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varSelectionRF.R
\name{varSelectionRF}
\alias{varSelectionRF}
\title{Variable selection function that can be provided to \code{nonlinearICP} - it
is then applied to pre-select a set of variables before running the ICP procedure
on this subset. Here, the variable selection is based on random forest variable
importance measures.}
\usage{
varSelectionRF(X, Y, env, verbose, nSelect = sqrt(ncol(X)),
  useMtry = sqrt(ncol(X)), ntree = 100)
}
\arguments{
\item{X}{A (nxp)-dimensional matrix (or data frame) with n observations of p variables.}

\item{Y}{Response vector (n x 1)}

\item{env}{Indicator of the experiment or the intervention type an observation belongs to.
A numeric vector of length n. Has to contain at least two different unique values.}

\item{verbose}{If \code{FALSE}, most messages are supressed.}

\item{nSelect}{Number of variables to select. Defaults to \code{sqrt(ncol(X))}.}

\item{useMtry}{Random forest parameter \code{mtry}. Defaults to \code{sqrt(ncol(X))}.}

\item{ntree}{Random forest parameter \code{ntree}. Defaults to 100.}
}
\value{
A vector containing the indices of the selected variables.
}
\description{
Variable selection function that can be provided to \code{nonlinearICP} - it
is then applied to pre-select a set of variables before running the ICP procedure
on this subset. Here, the variable selection is based on random forest variable
importance measures.
}
