% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverse_geo_lite_sf.R
\name{reverse_geo_lite_sf}
\alias{reverse_geo_lite_sf}
\title{Reverse Geocoding API for OSM objects in Spatial format}
\usage{
reverse_geo_lite_sf(
  lat,
  long,
  address = "address",
  full_results = FALSE,
  return_coords = TRUE,
  verbose = FALSE,
  custom_query = list(),
  points_only = TRUE
)
}
\arguments{
\item{lat}{latitude values in numeric format. Must be in the range
\verb{[-90, 90]}.}

\item{long}{longitude values in numeric format. Must be in the range
\verb{[-180, 180]}.}

\item{address}{address column name in the output data (default  \code{"address"}).}

\item{full_results}{returns all available data from the API service.
If \code{FALSE} (default) only latitude, longitude and address columns are
returned. See also \code{return_addresses}.}

\item{return_coords}{return input coordinates with results if \code{TRUE}.}

\item{verbose}{if \code{TRUE} then detailed logs are output to the console.}

\item{custom_query}{API-specific parameters to be used, passed as a named
list (ie. \code{list(zoom = 3)}). See \strong{Details}.}

\item{points_only}{Logical \code{TRUE/FALSE}. Whether to return only spatial
points (\code{TRUE}, which is the default) or potentially other shapes as
provided by the Nominatim API (\code{FALSE}). See \strong{About Geometry Types}.}
}
\value{
A \code{sf} object with the results.
}
\description{
Generates an address from a latitude and longitude. Latitudes must be
between \verb{[-90, 90]} and longitudes between \verb{[-180, 180]}. This function
returns the \pkg{sf} spatial object associated with the query, see
\code{\link[=reverse_geo_lite]{reverse_geo_lite()}} for retrieving the data in \code{tibble} format.
}
\details{
See \url{https://nominatim.org/release-docs/develop/api/Reverse/} for additional
parameters to be passed to \code{custom_query}.
}
\section{About Zooming}{


Use the option \code{custom_query = list(zoom = 3)} to adjust the output. Some
equivalences on terms of zoom:\tabular{rl}{
   zoom \tab address_detail \cr
   3 \tab country \cr
   5 \tab state \cr
   8 \tab county \cr
   10 \tab city \cr
   14 \tab suburb \cr
   16 \tab major streets \cr
   17 \tab major and minor streets \cr
   18 \tab building \cr
}
}

\section{About Geometry Types}{


The parameter \code{points_only} specifies whether the function results will be
points (all Nominatim results are guaranteed to have at least point
geometry) or possibly other spatial objects.

Note that the type of geometry returned in case of \code{points_only = FALSE}
will depend on the object being geocoded:
\itemize{
\item administrative areas, major buildings and the like will be
returned as polygons
\item rivers, roads and their like as lines
\item amenities may be points even in case of a \code{points_only = FALSE} call
}

The function is vectorized, allowing for multiple addresses to be geocoded;
in case of \code{points_only = FALSE}  multiple geometry types may be returned.
}

\examples{
\dontshow{if (nominatim_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
library(ggplot2)


Coliseum <- geo_lite("Coliseo, Rome, Italy")

# Coliseum
Col_sf <- reverse_geo_lite_sf(
  lat = Coliseum$lat,
  lon = Coliseum$lon,
  points_only = FALSE
)

ggplot(Col_sf) +
  geom_sf()

# City of Rome - Zoom 10

Rome_sf <- reverse_geo_lite_sf(
  lat = Coliseum$lat,
  lon = Coliseum$lon,
  custom_query = list(zoom = 10),
  points_only = FALSE
)

ggplot(Rome_sf) +
  geom_sf()

# County - Zoom 8

County_sf <- reverse_geo_lite_sf(
  lat = Coliseum$lat,
  lon = Coliseum$lon,
  custom_query = list(zoom = 8),
  points_only = FALSE
)

ggplot(County_sf) +
  geom_sf()
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=reverse_geo_lite]{reverse_geo_lite()}}

Reverse geocoding coordinates: 
\code{\link{reverse_geo_lite}()}

Get spatial (`sf`) objects: 
\code{\link{bbox_to_poly}()},
\code{\link{geo_address_lookup_sf}()},
\code{\link{geo_amenity_sf}()},
\code{\link{geo_lite_sf}()}
}
\concept{reverse}
\concept{spatial}
