% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src_couchdb.R
\name{src_couchdb}
\alias{src_couchdb}
\title{Setup a CouchDB database connection}
\usage{
src_couchdb(
  host = "127.0.0.1",
  port = 5984,
  path = NULL,
  transport = "http",
  user = NULL,
  pwd = NULL,
  headers = NULL
)
}
\arguments{
\item{host}{(character) host value, default: 127.0.0.1}

\item{port}{(integer/numeric) Port. Remember that if you don't want a port
set, set this parameter to NULL. Default: 5984}

\item{path}{(character) context path that is appended to the end
of the url, e.g., bar in http://foo.com/bar. Default: NULL, ignored}

\item{transport}{(character) http or https. Default: http}

\item{user}{(character) Username, if any}

\item{pwd}{(character) Password, if any}

\item{headers}{(list) list of named headers}
}
\value{
A \code{nodbi} source object
}
\description{
Setup a CouchDB database connection
}
\details{
Uses \pkg{sofa} as backend. \pkg{nodbi} creates or uses
a CouchDB database with JSON documents. If documents do not have
root-level \verb{_id}'s, UUID's are created as \verb{_id}'s. Function
\code{\link[=docdb_update]{docdb_update()}} uses \code{\link[jqr:jqr]{jqr::jqr()}} to implement patching JSON.
For a benchmark, see \url{https://github.com/ropensci/nodbi#benchmark}.
}
\examples{
\dontrun{
con <- src_couchdb()
print(con)
}
}
