% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{SkewTk}
\alias{SkewTk}
\title{Skewness of Cuzick and Edwards \eqn{T_k} Test statistic}
\usage{
SkewTk(n1, k, a)
}
\arguments{
\item{n1}{Number of cases}

\item{k}{Integer specifying the number of NNs (of subject \eqn{i})}

\item{a}{\eqn{A_{ij}} matrix which is the output of the function \code{\link{aij.mat}}.}
}
\value{
The skewness of Cuzick and Edwards \eqn{T_k} test statistic for disease clustering
}
\description{
This function estimates the skewness of Cuzick and Edwards \eqn{T_k} test statistic under the RL hypothesis.
Skewness of a random variable \eqn{T} is defined as \eqn{E(T-\mu)^3/(E(T-\mu)^2)^{1.5}} where \eqn{\mu=E T}.

Skewness is used for Tango's correction to Cuzick and Edwards \code{k}NN test statistic, \eqn{T_k}.
Tango's correction is a chi-square approximation, and its degrees of freedom is estimated using the skewness
estimate (see page 121 of \insertCite{tango:2007;textual}{nnspat}).

The argument, \eqn{n_1}, is the number of cases (denoted as \code{n1} as an argument) 
and \code{k} is the number of NNs considered in \eqn{T_k} test statistic.
The argument of the function is the \eqn{A_{ij}} matrix, \code{a}, which is the output of the function \code{\link{aij.mat}}.
However, inside the function we symmetrize the matrix \code{a} as \code{b <- (a+a^t)/2}, to facilitate the formulation.

The number of cases are denoted as \eqn{n_1} and number of controls as \eqn{n_0} in this function
to match the case-control class labeling,
which is just the reverse of the labeling in \insertCite{cuzick:1990;textual}{nnspat}.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(0:1,n,replace = TRUE)
n1<-sum(cls==1)

k<-sample(1:5,1) # try also 3, 5, sample(1:5,1)
k
a<-aij.mat(Y,k)

SkewTk(n1,k,a)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{ceTk}}, \code{\link{EV.Tk}}, and \code{\link{varTk}}
}
\author{
Elvan Ceyhan
}
