% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_split_junctions.R
\name{st_split_junctions}
\alias{st_split_junctions}
\title{Split line layer at intersections (junctions)}
\usage{
st_split_junctions(x, progress = TRUE)
}
\arguments{
\item{x}{Object of class \code{sf}}

\item{progress}{Display progress bar? (default \code{TRUE})}
}
\value{
Normalized \code{sf} line layer
}
\description{
Split \code{sf} line layer at intersections (junctions). For example, this can be a preliminary step before using the line layer in routing applications, where all junctions need to be routable.
}
\examples{
data(line)

# Line layer with single feature
line = st_sf(st_union(line))

# Line layer split at intersections
line1 = st_split_junctions(line)

# Plot
opar = par(mfrow = c(1, 2))
plot(st_geometry(line), col = sample(hcl.colors(nrow(line), "Set 2")), lwd = 5, main = "before")
text(st_coordinates(st_centroid(line)), as.character(1:nrow(line)))
plot(st_geometry(line1), col = sample(hcl.colors(nrow(line1), "Set 2")), lwd = 5, main = "after")
text(st_coordinates(st_centroid(line1)), as.character(1:nrow(line1)))
par(opar)
}
