% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/001functions.R
\name{mlsem}
\alias{mlsem}
\title{\code{mlsem} returns expression of log-likelihood for joint normal distribution, 
for maximum likelihood (ML), Simultaneous Equations Models (SEM) variant.}
\usage{
mlsem(cheqs0, fixed_term = TRUE)
}
\arguments{
\item{cheqs0}{Strings defining equations of errors.}

\item{fixed_term}{if \code{TRUE} fixed term -(k/2)*log(2*pi) (k number of equations) is included}
}
\value{
List with LL expressions of joint normal distribution, first element is string with 
expression for derivative calculations, the second - string for evaluation.
}
\description{
\code{mlsem} returns expression of log-likelihood for joint normal distribution, 
for maximum likelihood (ML), Simultaneous Equations Models (SEM) variant.
}
\examples{
# normal distribution
eq_c <- c("Tw ~ ((((PH) + (tw)) * (ta - Tc) + Ec/w * (1 + (tw)) + sqrt((Ec/w *(1 + (tw)) +
(ta - Tc) * ((PH) + (tw)))^2 - 4 * Ec/w * (ta -Tc) * (tw) * (1 + (PH) + (tw))))/(2 * (1 + (PH)
 + (tw))))",
"Tf1 ~ (th1) *(Tw - Tc)",
"Ef1 ~ (ph1)/(PH) * (w * Tw - Ec)")
parl <- c("tw","PH","th1","ph1")
para_cont <- get_par(parl, eq_c)
cheqs0 <- para_cont$cheqs0
res <- mlsem(cheqs0, fixed_term=FALSE)
}
