% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSratio.R
\name{SSratio}
\alias{SSratio}
\alias{ratio}
\title{self start for a rational curve}
\usage{
ratio(x, a, b, c, d)

SSratio(x, a, b, c, d)
}
\arguments{
\item{x}{input vector}

\item{a}{parameter related to the maximum value of the response (numerator)}

\item{b}{power exponent for numerator}

\item{c}{parameter related to the maximum value of the response (denominator)}

\item{d}{power exponent for denominator}
}
\value{
a numeric vector of the same length as x containing parameter estimates for equation specified

ratio: vector of the same length as x using a rational function
}
\description{
Self starter for a rational curve
}
\details{
The equation is: \deqn{ a * x ^ c / (1 + b * x ^ d)}

This function is described in Archontoulis and Miguez (2015) - (doi:10.2134/agronj2012.0506).  
One example application is in Bril et al. (1994) \url{https://edepot.wur.nl/333930} - pages 19 and 21. 
The parameters are difficult to interpret, but the function is very flexible. I have not tested this, 
but it might be beneficial to re-scale x and y to the (0,1) range if this function is hard to fit.
\url{https://en.wikipedia.org/wiki/Rational_function}.
}
\examples{
\donttest{
require(ggplot2)
require(minpack.lm)
set.seed(1234)
x <- 1:100
y <- ratio(x, 1, 0.5, 1, 1.5) + rnorm(length(x), 0, 0.025)
dat <- data.frame(x = x, y = y)
fit <- nlsLM(y ~ SSratio(x, a, b, c, d), data = dat)
## plot
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
}
}
