% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_lme.R
\name{simulate_lme}
\alias{simulate_lme}
\title{Simulate values from an object of class \code{\link[nlme]{lme}}}
\usage{
simulate_lme(
  object,
  nsim = 1,
  psim = 1,
  value = c("matrix", "data.frame"),
  ...
)
}
\arguments{
\item{object}{object of class \code{\link[nlme]{lme}} or \code{\link[nlme]{gls}}}

\item{nsim}{number of samples, default 1}

\item{psim}{parameter simulation level, 0: for fitted values, 1: for simulation from 
fixed parameters (assuming a fixed vcov matrix), 2: for simulation considering the 
uncertainty in the residual standard error (sigma), this returns data which
will appear similar to the observed values. 3: in addition samples a new set of random effects.}

\item{value}{whether to return a matrix (default) or an augmented data frame}

\item{...}{additional arguments (it is possible to supply a newdata this way)}
}
\value{
It returns a vector with simulated values with length equal to the number of rows 
in the original data
}
\description{
Simulate values from an object of class lme. Unequal variances, 
as modeled using the \sQuote{weights} option are supported, and there is
experimental code for considering the \sQuote{correlation} structure.
}
\details{
This function is based on \code{\link[nlme]{predict.lme}} function

It uses function \code{\link[MASS]{mvrnorm}} to generate new values for the coefficients
of the model using the Variance-Covariance matrix \code{\link{vcov}}. This variance-covariance matrix 
refers to the one for the parameters 'beta', not the one for the residuals.
}
\note{
I find the simulate.merMod in the lme4 pacakge confusing. There is use.u and several versions of re.form.
From the documentation it seems that if use.u = TRUE, then the current values of the random effects are used.
This would mean that it is equivalent to psim = 2 in this function. Then use.u = FALSE, would be equivalent 
to psim = 3. re.form allows for specifying the formula of the random effects.
}
\examples{
\donttest{
require(nlme)
data(Orange)

fm1 <- lme(circumference ~ age, random = ~ 1 | Tree, data = Orange)

sims <- simulate_lme(fm1, nsim = 10)

}
}
\seealso{
\code{\link[nlme]{predict.lme}}
}
