% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foce.R
\name{foceControl}
\alias{foceControl}
\title{Control options for the foce estimation method}
\usage{
foceControl(sigdig = 3, ..., interaction = FALSE)
}
\arguments{
\item{sigdig}{Optimization significant digits. This controls:

\itemize{

 \item The tolerance of the inner and outer optimization is \code{10^-sigdig}

 \item The tolerance of the ODE solvers is
 \code{0.5*10^(-sigdig-2)}; For the sensitivity equations and
 steady-state solutions the default is \code{0.5*10^(-sigdig-1.5)}
 (sensitivity changes only applicable for liblsoda)

 \item The tolerance of the boundary check is \code{5 * 10 ^ (-sigdig + 1)}

}}

\item{...}{Parameters used in the default `foceiControl()`}

\item{interaction}{Interaction term for the model, in this case the
default is `FALSE`; it cannot be changed, use `focei` instead}
}
\value{
foceControl object
}
\description{
This is the first order option without the interaction between
residuals and etas.
}
\examples{

foceControl()
}
\author{
Matthew L. Fidler
}
