% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlmixrGrad.R
\name{nlmixrHess}
\alias{nlmixrHess}
\title{Calculate Hessian}
\usage{
nlmixrHess(par, fn, ..., envir = parent.frame())
}
\arguments{
\item{par}{Initial values for the parameters to be optimized over.}

\item{fn}{A function to be minimized (or maximized), with first
   argument the vector of parameters over which minimization is to take
   place.  It should return a scalar result.}

\item{...}{Extra arguments sent to \code{\link{nlmixrGill83}}}

\item{envir}{an environment within which to evaluate the call.  This
    will be most useful if \code{what} is a character string and
    the arguments are symbols or quoted expressions.}
}
\value{
Hessian matrix based on Gill83
}
\description{
Unlike `stats::optimHess` which assumes the gradient is accurate,
nlmixrHess does not make as strong an assumption that the gradient
is accurate but takes more function evaluations to calculate the
Hessian.  In addition, this procedures optimizes the forward
difference interval by \code{\link{nlmixrGill83}}
}
\details{
If you have an analytical gradient function, you should use
`stats::optimHess`
}
\examples{
 func0 <- function(x){ sum(sin(x))  }
 x <- (0:10)*2*pi/10
 nlmixrHess(x, func0)

fr <- function(x) {   ## Rosenbrock Banana function
    x1 <- x[1]
    x2 <- x[2]
    100 * (x2 - x1 * x1)^2 + (1 - x1)^2
}
grr <- function(x) { ## Gradient of 'fr'
    x1 <- x[1]
    x2 <- x[2]
    c(-400 * x1 * (x2 - x1 * x1) - 2 * (1 - x1),
       200 *      (x2 - x1 * x1))
}

h1 <- optimHess(c(1.2,1.2), fr, grr)

h2 <- optimHess(c(1.2,1.2), fr)

## in this case h3 is closer to h1 where the gradient is known

h3 <- nlmixrHess(c(1.2,1.2), fr)
}
\references{
\url{https://v8doc.sas.com/sashtml/ormp/chap5/sect28.htm}
}
\seealso{
\code{\link{nlmixrGill83}}, \code{\link{optimHess}}
}
\author{
Matthew Fidler
}
