% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vdraw_sc_step_regular_cpp.R
\name{vdraw_sc_step_regular_cpp}
\alias{vdraw_sc_step_regular_cpp}
\title{Vectorized sampling from NHPPPs with piecewise constant intensities
with same interval lengths (C++)}
\usage{
vdraw_sc_step_regular_cpp(
  lambda_matrix = NULL,
  Lambda_matrix = NULL,
  range_t = NULL,
  subinterval = NULL,
  tol = 10^-6,
  atmost1 = FALSE,
  atmostB = NULL
)
}
\arguments{
\item{lambda_matrix}{(matrix) intensity rates, one per interval}

\item{Lambda_matrix}{(matrix) integrated intensity rates at the end of each interval}

\item{range_t}{(vector, double) \code{t_min} and \code{t_max}}

\item{subinterval}{(matrix, double) subinterval of \code{range_t} to sample from}

\item{tol}{(scalar, double) tolerance for the number of events}

\item{atmost1}{boolean, draw at most 1 event time}

\item{atmostB}{If not NULL, draw at most B (B>0) event times. NULL means ignore.}
}
\value{
a vector of event times t
if no events realize, it will have 0 length
}
\description{
Simulate a piecewise constant-rate Poisson Point Process over \verb{(t_min, t_max]} (inversion method)
where the intervals have the same length (are "regular").
}
\examples{
x <- vdraw_sc_step_regular(Lambda_matrix = matrix(1:5, nrow = 1))
}
