% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhl_schedule.R
\name{nhl_url_schedule}
\alias{nhl_url_schedule}
\title{Create an NHL API URL for schedules}
\usage{
nhl_url_schedule(seasons = NULL, teamIds = NULL, startDate = NULL,
  endDate = NULL, gameTypes = NULL, expand = NULL)
}
\arguments{
\item{seasons}{\code{numeric()}, \code{integer()} or \code{character()},
vector of starting years of desired seasons in \code{YYYY}
format, e.g. \code{1995} or \code{"1995"} for season 1995-1996.
Accepts vectors such as \code{c(1995:2000, 2010)} to generate
multiple seasons.

Alternatively, also accepts \code{character()} with seasons in the
format \code{"YYYYZZZZ"}, where \code{ZZZZ = YYYY + 1}, e.g. \code{"19951996"}.
This is the format that ultimately gets sent to the NHL API.

Some API endpoints, notably \code{seasons} exposed via \code{\link[=nhl_seasons]{nhl_seasons()}}
also allow the value \code{"current"} to passed. This value will be
returned unchanged.}

\item{teamIds}{\code{integer()}, ids of the teams or \code{NULL} (default)
for all teams. As of end of 2019, the valid team ids seem to be
in the \code{1:54} range.}

\item{startDate}{\code{character(1)}, date in the format \code{"YYYY-MM-DD"}
defining the start of the date interval for which the schedule is
to be retrieved.}

\item{endDate}{\code{character(1)}, date in the format \code{"YYYY-MM-DD"}
defining the end of the date interval for which the schedule is
to be retrieved.}

\item{gameTypes}{\code{character()}, defining the game types to retrieve.
Valid game types are for example \code{"R"} for regular season or \code{"P"}
for playoffs. See \code{\link[=nhl_md_game_types]{nhl_md_game_types()}} for all values and their
descriptions.}

\item{expand}{\code{character()}, of parameters passed as \code{expand}
to the API URL. Some valid examples seem to be \code{"round.series"}
and \code{"schedule.broadcasts"}, \code{"schedule.linescore"},
\code{"schedule.ticket"}. \code{NULL} for no expand parameter.}
}
\value{
\code{character()}, vector of URLs.
}
\description{
Create an NHL API URL for schedules
}
\examples{
 nhlapi:::nhl_url_schedule(seasons = 2015:2016)
 nhlapi:::nhl_url_schedule(
   startDate = "2018-01-02",
   endDate = "2018-01-02"
 )
 nhlapi:::nhl_url_schedule(
   startDate = "2018-01-02",
   endDate = "2018-01-02",
   teamIds = c(29, 30),
   expand = "schedule.linescore"
 )

}
