% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhl_url.R
\name{nhl_url}
\alias{nhl_url}
\title{Create an NHL API URL}
\usage{
nhl_url(endPoint = NULL, suffixes = NULL, params = NULL,
  baseUrl = getOption("nhlapi_baseurl"))
}
\arguments{
\item{endPoint}{\code{character(1)}, the API endpoint.}

\item{suffixes}{\code{list()}, of suffixes that will be
concatenated to the end of the URLs, separated by \code{/}.}

\item{params}{\code{named list()} of parameters that will be
concatenated to the end of the URLs after \code{?}. Parameters
can have multiple values, in which case multiple URLs
are created. Multiple parameters are separated by \code{&}.}

\item{baseUrl}{\code{character(1)}, URL of the NHL API base location.}
}
\value{
\code{character()}, the created URLs.
}
\description{
Create an NHL API URL
}
\examples{
  nhlapi:::nhl_url("people", "8477474")

}
