% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhanes_tables.R
\name{nhanesManifest}
\alias{nhanesManifest}
\title{Download and parse NHANES manifests}
\usage{
nhanesManifest(
  which = c("public", "limitedaccess", "variables"),
  sizes = FALSE,
  verbose = getOption("verbose"),
  use_cache = TRUE,
  max_age = 24 * 60 * 60
)
}
\arguments{
\item{which}{Either "public" or "limitedaccess" to get a manifest
of available tables, or "variables" to get a manifest of
available variables.}

\item{sizes}{Logical, whether to compute data file sizes (as
reported by the server) and include them in the result.}

\item{verbose}{Logical flag indicating whether information on
progress should be reported.}

\item{use_cache}{Logical flag indicating whether a cached version
(from a previous download in the same session) should be used.}

\item{max_age}{Maximum allowed age of the cache in seconds
(defaults to 24 hours). Cached versions that are older are
ignored, even if available.}
}
\value{
A data frame, with columns that depend on
  \code{which}. For a manifest of tables, columns are "Table",
  "DocURL", "DataURL", "Years", "Date.Published". If \code{sizes =
  TRUE}, an additional column "DataSize" giving the data file
  sizes in bytes (as reported by the server) is included. For
  limited access tables, the "DataURL" and "DataSize" columns are
  omitted. For a manifest of variables, columns are "VarName",
  "VarDesc", "Table", "TableDesc", "BeginYear", "EndYear",
  "Component", and "UseConstraints".
}
\description{
Downloads and parses NHANES manifests for public data
(available at
\url{https://wwwn.cdc.gov/Nchs/Nhanes/search/DataPage.aspx}),
limited access data
(\url{https://wwwn.cdc.gov/Nchs/Nhanes/search/DataPage.aspx?Component=LimitedAccess}),
and variables
(\url{https://wwwn.cdc.gov/nchs/nhanes/search/variablelist.aspx?Component=Demographics}, etc.),
and returns them as data frames.
}
\note{
Duplicate rows are removed from the result. Most of these
  duplicates arise from duplications in the source tables for
  multi-cycle tables (which are repeated once for each cycle). One
  special case is the WHQ table which has two variables, WHD120
  and WHQ030, duplicated with differing variable
  descriptions. These are removed explicitly, keeping only the
  first occurrence.
}
\examples{
\donttest{manifest <- nhanesManifest(sizes = FALSE)}
\donttest{dim(manifest)}

}
