% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/nhanes.R
\name{nhanesTranslate}
\alias{nhanesTranslate}
\title{Display code translation information for the specified table.}
\usage{
nhanesTranslate(nh_table, colname, details = FALSE)
}
\arguments{
\item{nh_table}{The name of the specific table to retrieve.}

\item{colname}{The name of the column to translate}

\item{details}{If TRUE. then all available table translation information is displayed.}
}
\value{
The code translation
}
\description{
Returns code translations which is especially useful for categorical tables,
which includes most NHANES tables.
}
\details{
Code translation tables are retrieved via webscraping using rvest.
Many of the NHANES data tables have encoded values. E.g. 1 = 'Male', 2 = 'Female'.
By default, the codes and the translated values are returned in a data frame.
}
\examples{
nhanesTranslate('DEMO_B', 'DMDBORN')
nhanesTranslate('BPX_F', 'BPACSZ', details=TRUE)
}

