% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{load_4th_pbp}
\alias{load_4th_pbp}
\title{Load calculated 4th down probabilities from \code{nflfastR} data}
\usage{
load_4th_pbp(seasons, fast = FALSE)
}
\arguments{
\item{seasons}{Seasons to load. Must be 2014 and later.}

\item{fast}{Defaults to FALSE. If TRUE, loads pre-computed decisions from repository}
}
\value{
\code{nflfastR} data on 4th downs with the \code{add_4th_probs()} columns added and also the following:
\describe{
\item{go}{100 if a team went for it on 4th down, 0 otherwise. It's 100 and 0 as a convenience for obtaining percent of times going for it.}
}
}
\description{
Load calculated 4th down probabilities from \code{nflfastR} data.
}
\examples{
\donttest{
try({# Wrap in try to avoid CRAN test problems
probs <- load_4th_pbp(2019:2020)
dplyr::glimpse(probs)
})
\dontshow{
# Close open connections for R CMD Check
future::plan("sequential")
}
}
}
