% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{power2}
\alias{power2}
\title{Power Simulations for Permutation Tests}
\usage{
power2(
  model1 = "gnp",
  model2 = "k_regular",
  n1 = 20L,
  n2 = 20L,
  size1 = NULL,
  prob1 = NULL,
  size2 = NULL,
  prob2 = NULL,
  lambda1 = NULL,
  lambda2 = NULL,
  pref.matrix1 = NULL,
  pref.matrix2 = NULL,
  representation = "adjacency",
  distance = "frobenius",
  stats = c("flipr:t_ip", "flipr:f_ip"),
  B = 1000L,
  alpha = 0.05,
  test = "exact",
  k = 5L,
  R = 1000L,
  seed = NULL
)
}
\arguments{
\item{model1}{A string specifying the model to be used for sample 1 among
\code{"sbm"}, \code{"k_regular"}, \code{"gnp"}, \code{"smallworld"},
\code{"pa"}, \code{"poisson"} and \code{"binomial"}. Default is
\code{"gnp"}.}

\item{model2}{A string specifying the model to be used for sample 2 among
\code{"sbm"}, \code{"k_regular"}, \code{"gnp"}, \code{"smallworld"},
\code{"pa"}, \code{"poisson"} and \code{"binomial"}. Default is
\code{"k_regular"}.}

\item{n1}{The size of sample 1 (default: 20L).}

\item{n2}{The size of sample 2 (default: 20L).}

\item{size1}{The number of trials for the binomial distribution of sample 1
(default: \code{NULL}). Must be specified if \code{model == "binomial"}.}

\item{prob1}{The probability of success of each trial for the binomial
distribution of sample 1 (default: \code{NULL}). Must be specified if
\code{model == "binomial"}.}

\item{size2}{The number of trials for the binomial distribution of sample 2
(default: \code{NULL}). Must be specified if \code{model == "binomial"}.}

\item{prob2}{The probability of success of each trial for the binomial
distribution of sample 2 (default: \code{NULL}). Must be specified if
\code{model == "binomial"}.}

\item{lambda1}{The mean of the Poisson distribution of sample 1 (default:
\code{NULL}). Must be specified if \code{model == "poisson"}.}

\item{lambda2}{The mean of the Poisson distribution of sample 2 (default:
\code{NULL}). Must be specified if \code{model == "poisson"}.}

\item{pref.matrix1}{A matrix giving the Bernoulli rates for the SBM generator
of sample 1 (default: \code{NULL}). Must be specified if \code{model ==
  "sbm"}.}

\item{pref.matrix2}{A matrix giving the Bernoulli rates for the SBM generator
of sample 2 (default: \code{NULL}). Must be specified if \code{model ==
  "sbm"}.}

\item{representation}{A string specifying the desired type of representation,
among: \code{"adjacency"}, \code{"laplacian"} and \code{"modularity"}.
Defaults to \code{"adjacency"}.}

\item{distance}{A string specifying the chosen distance for calculating the
test statistic, among: \code{"hamming"}, \code{"frobenius"},
\code{"spectral"} and \code{"root-euclidean"}. Defaults to
\code{"frobenius"}.}

\item{stats}{A character vector specifying the chosen test statistic(s),
among: \code{"original_edge_count"}, \code{"generalized_edge_count"},
\code{"weighted_edge_count"}, \code{"student_euclidean"}, \code{"welch_euclidean"} or any
statistics based on inter-point distances available in the \strong{flipr}
package: \code{"flipr:student_ip"}, \code{"flipr:fisher_ip"}, \code{"flipr:bg_ip"},
\code{"flipr:energy_ip"}, \code{"flipr:cq_ip"}. Defaults to \code{c("flipr:student_ip", "flipr:fisher_ip")}.}

\item{B}{The number of permutation or the tolerance. If this number is lower
than \code{1}, it is intended as a tolerance. Otherwise, it is intended as
the number of required permutations. Defaults to \code{1000L}.}

\item{alpha}{Significance level for hypothesis testing (default:
\code{0.05}).}

\item{test}{A character string specifying the formula to be used to compute
the permutation p-value. Choices are \code{"estimate"}, \code{"upper_bound"} and
\code{"exact"}. Defaults to \code{"exact"} which provides exact tests.}

\item{k}{An integer specifying the density of the minimum spanning tree used
for the edge count statistics. Defaults to \code{5L}.}

\item{R}{The number of Monte-Carlo runs used to estimate the power (default:
1000L).}

\item{seed}{An integer specifying the seed to start randomness from (default:
uses clock).}
}
\value{
A numeric value estimating the power of the test.
}
\description{
This function provides a Monte-Carlo estimate of the power of the permutation
tests proposed in this package.
}
\details{
Currently, six scenarios of pairs of populations are implemented. Scenario 0
allows to make sure that all our permutation tests are exact.
}
\examples{
power2(R = 10, B = 100, seed = 1234)
}
