% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_datasets.R
\name{get_datasets.default}
\alias{get_datasets.default}
\title{Get Dataset Default}
\usage{
\method{get_datasets}{default}(x, ...)
}
\arguments{
\item{x}{Use a single number to extract site information}

\item{...}{accepted arguments, see details for more information.}
}
\value{
\code{sites} object with full metadata up to the \code{dataset} level
}
\description{
Get Dataset Default
}
\examples{
\donttest{
# To find all datasets with a min altitude of 12 and a max altitude of 25:
sites_12to25 <- get_datasets(altmin=12, altmax=25, limit=2)
# To find all datasets in Brazil
brazil <- '{"type": "Polygon",
"coordinates": [[
 [-73.125, -9.102096738726443],
 [-56.953125,-33.137551192346145],
 [-36.5625,-7.710991655433217],
 [-68.203125,13.923403897723347],
 [-73.125,-9.102096738726443]]]}'
brazil_datasets <- get_datasets(loc = brazil[1], limit=2)
}
}
