% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_agefile.R
\name{write_agefile}
\alias{write_agefile}
\title{Write age control file to disk formatted for either Bacon or Clam}
\usage{
write_agefile(download, chronology = 1, path, corename, cal.prog = "Bacon")
}
\arguments{
\item{download}{A single site returned by \code{get_download}.}

\item{chronology}{Default is \code{1}, the default chronology for the core.  If a core has more than one chronology the user can define a different set of chronological controls.}

\item{path}{The location of the 'Cores' folder & working directory for Bacon.  Do not include "Cores" in the path name.}

\item{corename}{The intended handle for the core, to be used in writing to file.}

\item{cal.prog}{The method intended to build the age model, either \code{'Bacon'} or \code{'Clam'}.}
}
\value{
This command returns a file in location \code{path/Cores} containing all the relevant information required to build either the default or prior chronology for a core.
}
\description{
Passing in a download object the function outputs a Bacon or Clam formatted file to a
user defined destination for age modelling with existing age-depth modeling software.
}
\examples{
\dontrun{
# Find a particular record:

three_pines <- get_download(get_dataset(get_site("Three Pines Bog"), datasettype = "pollen"))

# You will need to edit the `path` argument here to point to a directory that 
# contains a `Cores` directory.

write_agefile(download = three_pines[[1]], 
              path = "./inst", 
              corename = "THREEPINES", 
              cal.prog = "Bacon")
}
}
\author{
Simon J. Goring \email{simon.j.goring@gmail.com}
}
\references{
Neotoma Project Website: http://www.neotomadb.org
API Reference:  http://api.neotomadb.org/doc/resources/contacts
}
\keyword{API}
\keyword{Neotoma}
\keyword{Palaeoecology}

