% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdfDimensionTime.R
\name{time,ncdfDimensionTime-method}
\alias{time,ncdfDimensionTime-method}
\title{Get the full time specification of the dimension}
\usage{
\S4method{time}{ncdfDimensionTime}(x)
}
\arguments{
\item{x}{A \code{ncdfDimensionTime} instance.}
}
\value{
An instance of the \code{CFtime} class.
}
\description{
This method returns the \code{CFtime} instance that manages all the conversions
and processing for this dimension. See package \code{CFtime} for more details.
}
\examples{
fn <- system.file("extdata",
                  "pr_day_EC-Earth3-CC_ssp245_r1i1p1f1_gr_20240101-20241231_vncdfCF.nc",
                  package = "ncdfCF")
ds <- open_ncdf(fn)
time(ds[["time"]])
}
