% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign.grp.R
\name{assign.grp}
\alias{assign.grp}
\alias{assign.grp,data.frame-method}
\alias{assign.grp,nonbimatch-method}
\title{Random Group Assignment}
\usage{
assign.grp(matches, seed = 68, ...)
}
\arguments{
\item{matches}{A data.frame or nonbimatch object.  Contains information on
how to match the covariate data set.}

\item{seed}{Seed provided for random-number generation.  Default value of 68.}

\item{\dots}{Additional arguments, not used at the moment.}
}
\value{
original data.frame with treatment group column
}
\description{
Randomly assign each element into treatment group A or B.
}
\details{
This function takes the matched pairs generated by nonbimatch and randomly
assigns each element to a group.
}
\examples{

df <- data.frame(id=LETTERS[1:25], val1=rnorm(25), val2=rnorm(25))
df.dist <- gendistance(df, idcol=1)
df.mdm <- distancematrix(df.dist)
df.match <- nonbimatch(df.mdm)
assign.grp(df.match)
assign.grp(df.match$matches)

}
\seealso{
\code{\link{nonbimatch}}
}
\author{
Cole Beck
}
