% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nanoparquet.R
\name{parquet_column_types}
\alias{parquet_column_types}
\title{Map between R and Parquet data types}
\usage{
parquet_column_types(x, options = parquet_options())
}
\arguments{
\item{x}{Path to a Parquet file, or a data frame.}

\item{options}{Nanoparquet options, see \code{\link[=parquet_options]{parquet_options()}}.}
}
\value{
Data frame with columns:
\itemize{
\item \code{file_name}: file name.
\item \code{name}: column name.
\item \code{type}: (low level) Parquet data type.
\item \code{r_type}: the R type that corresponds to the Parquet type.
Might be \code{NA} if \code{\link[=read_parquet]{read_parquet()}} cannot read this column. See
\link{nanoparquet-types} for the type mapping rules.
\item \code{repetition_type}: whether the column in \code{REQUIRED} (cannot be
\code{NA}) or \code{OPTIONAL} (may be \code{NA}). \code{REPEATED} columns are not
currently supported by nanoparquet.
\item \code{logical_type}: Parquet logical type in a list column.
An element has at least an entry called \code{type}, and potentially
additional entries, e.g. \code{bit_width}, \code{is_signed}, etc.
}
}
\description{
This function works two ways. It can map the R types of a data frame to
Parquet types, to see how \code{\link[=write_parquet]{write_parquet()}} would write out the data
frame. It can also map the types of a Parquet file to R types, to see
how \code{\link[=read_parquet]{read_parquet()}} would read the file into R.
}
\seealso{
\code{\link[=parquet_metadata]{parquet_metadata()}} to read more metadata,
\code{\link[=parquet_info]{parquet_info()}} for a very short summary.
\code{\link[=parquet_schema]{parquet_schema()}} for the complete Parquet schema.
\code{\link[=read_parquet]{read_parquet()}}, \code{\link[=write_parquet]{write_parquet()}}, \link{nanoparquet-types}.
}
