getScatterFactor <- function(name){

#fpe <- read.table("scF.dat")

num <- switch(name,
	"H"=1,
	"H1-"=2,
	"He"=3,
	"Li"=4,
	"Li1+"=5,
	"Be"=6,
	"Be2+"=7,
	"B"=8,
	"C"=9,
	"Cval"=10,
	"N"=11,
	"O"=12,
	"O1-"=13,
	"O2-"=14,
	"F"=15,
	"F1-"=16,
	"Ne"=17,
	"Na"=18,
	"Na1+"=19,
	"Mg"=20,
	"Mg2+"=21,
	"Al"=22,
	"Al3+"=23,
	"Si"=24,
	"Siva"=25,
	"Si4+"=26,
	"P"=27,
	"S"=28,
	"Cl"=29,
	"Cl1-"=30,
	"Ar"=31,
	"K"=32,
	"K1+"=33,
	"Ca"=34,
	"Ca2+"=35,
	"Sc"=36,
	"Sc3+"=37,
	"Ti"=38,
	"Ti2+"=39,
	"Ti3+"=40,
	"Ti4+"=41,
	"V"=42,
	"V2+"=43,
	"V3+"=44,
	"V5+"=45,
	"Cr"=46,
	"Cr2+"=47,
	"Cr3+"=48,
	"Mn"=49,
	"Mn2+"=50,
	"Mn3+"=51,
	"Mn4+"=52,
	"Fe"=53,
	"Fe2+"=54,
	"Fe3+"=55,
	"Co"=56,
	"Co2+"=57,
	"Co3+"=58,
	"Ni"=59,
	"Ni2+"=60,
	"Ni3+"=61,
	"Cu"=62,
	"Cu1+"=63,
	"Cu2+"=64,
	"Zn"=65,
	"Zn2+"=66,
	"Ga"=67,
	"Ga3+"=68,
	"Ge"=69,
	"Ge4+"=70,
	"As"=71,
	"Se"=72,
	"Br"=73,
	"Br1-"=74,
	"Kr"=75,
	"Rb"=76,
	"Rb1+"=77,
	"Sr"=78,
	"Sr2+"=79,
	"Y"=80,
	"Zr"=81,
	"Zr4+"=82,
	"Nb"=83,
	"Nb3+"=84,
	"Nb5+"=85,
	"Mo"=86,
	"Mo3+"=87,
	"Mo5+"=88,
	"Mo6+"=89,
	"Tc"=90,
	"Ru"=91,
	"Ru3+"=92,
	"Ru4+"=93,
	"Rh"=94,
	"Rh3+"=95,
	"Rh4+"=96,
	"Pd"=97,
	"Pd2+"=98,
	"Pd4+"=99,
	"Ag"=100,
	"Ag1+"=101,
	"Ag2+"=102,
	"Cd"=103,
	"Cd2+"=104,
	"In"=105,
	"In3+"=106,
	"Sn"=107,
	"Sn2+"=108,
	"Sn4+"=109,
	"Sb"=110,
	"Sb3+"=111,
	"Sb5+"=112,
	"Te"=113,
	"I"=114,
	"I1-"=115,
	"Xe"=116,
	"Cs"=117,
	"Cs1+"=118,
	"Ba"=119,
	"Ba2+"=120,
	"La"=121,
	"La3+"=122,
	"Ce"=123,
	"Ce3+"=124,
	"Ce4+"=125,
	"Pr"=126,
	"Pr3+"=127,
	"Pr4+"=128,
	"Nd"=129,
	"Nd3+"=130,
	"Pm"=131,
	"Pm3+"=132,
	"Sm"=133,
	"Sm3+"=134,
	"Eu"=135,
	"Eu2+"=136,
	"Eu3+"=137,
	"Gd"=138,
	"Gd3+"=139,
	"Tb"=140,
	"Tb3+"=141,
	"Dy"=142,
	"Dy3+"=143,
	"Ho"=144,
	"Ho3+"=145,
	"Er"=146,
	"Er3+"=147,
	"Tm"=148,
	"Tm3+"=149,
	"Yb"=150,
	"Yb2+"=151,
	"Yb3+"=152,
	"Lu"=153,
	"Lu3+"=154,
	"Hf"=155,
	"Hf4+"=156,
	"Ta"=157,
	"Ta5+"=158,
	"W"=159,
	"W6+"=160,
	"Re"=161,
	"Os"=162,
	"Os4+"=163,
	"Ir"=164,
	"Ir3+"=165,
	"Ir4+"=166,
	"Pt"=167,
	"Pt2+"=168,
	"Pt4+"=169,
	"Au"=170,
	"Au1+"=171,
	"Au3+"=172,
	"Hg"=173,
	"Hg1+"=174,
	"Hg2+"=175,
	"Tl"=176,
	"Tl1+"=177,
	"Tl3+"=178,
	"Pb"=179,
	"Pb2+"=180,
	"Pb4+"=181,
	"Bi"=182,
	"Bi3+"=183,
	"Bi5+"=184,
	"Po"=185,
	"At"=186,
	"Rn"=187,
	"Fr"=188,
	"Ra"=189,
	"Ra2+"=190,
	"Ac"=191,
	"Ac3+"=192,
	"Th"=193,
	"Th4+"=194,
	"Pa"=195,
	"U"=196,
	"U3+"=197,
	"U4+"=198,
	"U6+"=199,
	"Np"=200,
	"Np3+"=201,
	"Np4+"=202,
	"Np6+"=203,
	"Pu"=204,
	"Pu3+"=205,
	"Pu4+"=206,
	"Pu6+"=207,
	"Am"=208,
	"Cm"=209,
	"Bk"=210,
	"Cf"=211
)
if(is.null(num))
  stop("unknown atom name \n", immediate. = TRUE)
  

scF <- fpe[num, ]

list(a1=scF$a1, a2=scF$a2, a3=scF$a3, a4=scF$a4, a5=scF$a5, 
     b1=scF$b1, b2=scF$b2, b3=scF$b3, b4=scF$b4, b5=scF$b5, 
	 c=scF$c)
} 




######################################################################################
scatterFactor <- function(scatterFactor, Q){
  s <- (Q/(4*pi))^2
  scatterFactor$a1*exp(-scatterFactor$b1*s) + scatterFactor$a2*exp(-scatterFactor$b2*s) +
   scatterFactor$a3*exp(-scatterFactor$b3*s) + scatterFactor$a4*exp(-scatterFactor$b4*s) +
   scatterFactor$a5*exp(-scatterFactor$b5*s) + scatterFactor$c
}