% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_constructors.R
\name{nb-img-classes}
\alias{nb-img-classes}
\alias{number_img}
\alias{brightness_img}
\title{Number and brightness image classes.}
\usage{
number_img(img, def, thresh, tau, filt)

brightness_img(img, def, thresh, tau, filt)
}
\arguments{
\item{img}{The calculated number or brightness image.}

\item{def}{The number or brightness definition used.}

\item{thresh}{A positive integer, possibly an object of class
\link[autothresholdr:th]{autothresholdr::th}. If the different channels of the image had different
thresholds, this argument may be specified as a vector or list (of positive
integers, possibly objects of class \link[autothresholdr:th]{autothresholdr::th}), one element for
each channel.}

\item{tau}{A positive number with an attribute \code{auto}. If the different
channels of the image had different \code{tau}s, this argument may be specified
as a list (of positive numbers with attributes \code{auto}), one element for
each channel.}

\item{filt}{A string, the filtering method used. Must be either \code{"mean"} or
\code{"median"}, or \code{NA} for no filtering. If the different channels of the
image had different filters, this may be specified as a character vector,
one element for each channel.}
}
\value{
An object of class \code{number_img} or \code{brightness_img}.
}
\description{
The \code{number_img} and \code{brightness_img} classes are designed to hold objects
which are images calculated from the \emph{number and brightness} technique.
}
\details{
An object of class \code{number_img} or \code{brightness_img} is a 4-dimensional array
of real numbers in the mould of an \link[ijtiff:ijtiff_img]{ijtiff_img} (indexed
as \code{img[y, x, channel, frame]}) with 4 attributes: \describe{\item{\code{def}}{Are
we using the \code{"N"} or \code{"n"} definition of number, or the \code{"B"} or \code{"epsilon"}
definition of brightness?} \item{\code{thresh}}{A positive integer, possibly an
object of class \link[autothresholdr:th]{autothresholdr::th} detailing which threshold and
thresholding method was used in preprocessing (in the multi-channel case, one
threshold per channel is given).} \item{\code{tau}}{A positive number indicating
the tau parameter used for detrending with an attribute \code{auto} which is a
logical indicating whether or not the tau parameter was chosen
automatically.}\item{\code{filt}}{Was mean or median filtering used in
postprocessing?}}
}
