% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{MedianFilterB}
\alias{MedianFilterB}
\alias{SmoothFilterB}
\title{Smooth and median filters with options for handling NAs.}
\usage{
MedianFilterB(mat, size = 1L, na_rm = FALSE, na_count = FALSE)

SmoothFilterB(mat, size = 1L, na_rm = FALSE, na_count = FALSE)
}
\arguments{
\item{mat}{A matrix (representing an image).}

\item{size}{An integer; the median filter radius.}

\item{na_rm}{Should \code{NA}s be ignored?}

\item{na_count}{If this is TRUE, in each median calculation, if the majority
of arguments are \code{NA}s, \code{NA} is returned but if the \code{NA}s are
in the minority, they are ignored as in \code{median(x, na.rm = TRUE)}.}
}
\value{
A matrix (the median filtered image).
}
\description{
These is an alternative to \link[EBImage:EBImage]{EBImage}'s
\link[EBImage:filter2]{filter2} and \link[EBImage:medianFilter]{medianFilter} for
smooth and median filtering respectively. These functions have many options
for dealing with \code{NA} values which \code{EBImage}'s functions lack.
}
\details{
The behavior at image boundaries is such as the source image has been padded
with pixels whose values equal the nearest border pixel value.
}
\examples{
m <- matrix(1:9, nrow = 3)
m[2:3, 2:3] <- NA
print(m)
MedianFilterB(m)
MedianFilterB(m, na_rm = TRUE)
MedianFilterB(m, na_count = TRUE)

MedianFilterB(m)
MedianFilterB(m, na_rm = TRUE)
MedianFilterB(m, na_count = TRUE)

}
