% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-item-interpreting.R
\name{naaccr_date}
\alias{naaccr_date}
\title{Parse NAACCR-formatted dates}
\usage{
naaccr_date(date)
}
\arguments{
\item{date}{Character vector of dates in NAACCR format (\code{"YYYYMMDD"}).}
}
\value{
A \code{Date} vector. Any incomplete or invalid dates are converted
  to \code{NA}. The original strings can be retrieved with the
  \code{\link{naaccr_encode}} function.
}
\description{
Parse NAACCR-formatted dates
}
\examples{
  input <- c("20151031", "201408  ", "99999999")
  d <- naaccr_date(input)
  d
  naaccr_encode(d, "dateOfDiagnosis")
}
