% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_otsu_discordance.R
\name{run_otsu_discordance}
\alias{run_otsu_discordance}
\title{Calculate Otsu discordance scores using specified threshold for an \code{mx_dataset} object.}
\usage{
run_otsu_discordance(
  mx_data,
  table,
  threshold_override = NULL,
  plot_out = FALSE,
  ...
)
}
\arguments{
\item{mx_data}{\code{mx_dataset} object used to compute Otsu discordance scores}

\item{table}{dataset in \code{mx_data} used to compute metrics. Options include: c("raw","normalized","both"), e.g. a y-axis parameter.}

\item{threshold_override}{optional user-defined function or alternate thresholding algorithm adaptable from Python skimage module \code{filters} (Note: not all algorithms in \code{filters} adapted). Options include supplying a function or any of the following: c("isodata", "li", "mean", "otsu", "triangle","yen").
More detail available here: https://scikit-image.org/docs/dev/api/skimage.filters.html.
If using a user-defined function, it must include a \code{thold_data} parameter.}

\item{plot_out}{boolean to generate Otsu discordance plots (default=FALSE)}

\item{...}{optional additional arguments for Otsu discordance functions}
}
\value{
\code{mx_dataset} object with analysis results of Otsu discordance in \code{otsu_data} table
}
\description{
The Otsu discordance analysis quantifies slide-to-slide agreement by summarizing
the distance between slide-level Otsu thresholds and the global Otsu threshold
for a given marker in a single metric.
}
\examples{
mx_data = mx_dataset(mxnorm::mx_sample, "slide_id", "image_id",
  c("marker1_vals","marker2_vals","marker3_vals"),
  c("metadata1_vals"))
mx_data = mx_normalize(mx_data, transform="log10",method="None")
## using `threshold_override` here in case users haven't installed `scikit-image`
mx_data = run_otsu_discordance(mx_data, table="normalized",
threshold_override = function(thold_data){quantile(thold_data, 0.5)})
}
\references{
Otsu, N. (1979). A threshold selection method from gray-level histograms. IEEE transactions on systems, man, and cybernetics, 9(1), 62-66.
}
