% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mws_main.R
\name{mwsApp}
\alias{mwsApp}
\title{Runs shiny app in multiple specified windows.}
\usage{
mwsApp(win_titles = c(), ui_win = list(), serv_calc = list(),
  serv_out = list())
}
\arguments{
\item{win_titles}{vector of strings, corresponding to window titles. Must be same length as ui_win, and titles must be same index as corresponding ui page in ui_win. No windows can be named 'WindowSelector'.}

\item{ui_win}{list of shiny ui pages. Must be same length as win_titles, and ui page must be same index as corresponding title in win_titles.}

\item{serv_calc}{a named list of functions that calculate variables derived from user input, to be used in rendering output. Each function is of the form function(input, calc), where input is the traditional shiny input, and calc is a named list of reactive values. Variables in must be accessed in the form input()$x. All calculated variables that are needed to render output should be added, named, to the calc list. When using reactive functions such as observeEvent(), each should be contained in a separate function. Note that these functions follow all shiny conventions (reactive values must be accessed in a reactive context, etc.).}

\item{serv_out}{a named list of functions that render output. Each function is of the form function(input, calc), where input is the traditional shiny input, and calc is a named list of reactive values that have calculated values derived from input. It returns the results of a shiny render function. The name of each function corresponds to its output label. Note that these functions follow all shiny conventions (reactive values must be accessed in a reactive context, etc.).}
}
\value{
shiny app object (i.e., it runs the app)
}
\description{
Runs shiny app in multiple specified windows.
}
\examples{
if(interactive()){
# Run a simple 2-window app, initially bringing up the window selector window:
ui_win <- list()
ui_win[[1]] <- fluidPage(numericInput(inputId = "click", label = "a", value = 1))
ui_win[[2]] <- fluidPage(plotOutput("clickplot"))
serv_out <- list()
serv_out[["clickplot"]] <- function(input, calc){
  renderPlot({
      plot(1:input$click,1:input$click)
  })
}
mwsApp(c("clickinput","clickoutput"),
    ui_win,
    list(),
    serv_out)
}
}
