% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMvtPar.R
\name{simulPareto}
\alias{simulPareto}
\title{Simulate Pareto random vectors}
\usage{
simulPareto(n, loc, vario, nCores = 1, cl = NULL)
}
\arguments{
\item{n}{Number of replicates desired.}

\item{loc}{Matrix of coordinates as given by \code{expand.grid()}.}

\item{vario}{Semi-variogram function.}

\item{nCores}{Number of cores used for the computation}

\item{cl}{Cluster instance as created by \code{makeCluster} of the \code{parallel} package. Make sure
the random number generator has been properly initialized with
\code{clusterSetRNGStream()}.}
}
\value{
List of \code{n} random vectors drawn from a mutlivariate Pareto distribution with semi-variogram \code{vario}.
}
\description{
\code{simulPareto} provides \code{n} replicates of the multivariate Pareto distribution
associated to log-Gaussian random function with semi-variogram \code{vario}.
}
\details{
The algorithm used here is based on the spectral representation of the Brown--Resnick
model as described in Dombry et al. (2015). It provides \code{n} replicates conditioned
that \code{mean(x) > 1} on the unit Frechet scale.
}
\examples{
#Define variogram function
vario <- function(h){
   1 / 2 * norm(h,type = "2")^1.5
}

#Define locations
loc <- expand.grid(1:4, 1:4)

#Simulate data
obs <- simulPareto(100, loc, vario)
}

