/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.wizard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.imageio.ImageIO;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import org.netbeans.api.wizard.displayer.InstructionsPanel;
import org.netbeans.modules.wizard.NbBridge;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardObserver;

public class InstructionsPanelImpl
extends JComponent
implements WizardObserver,
Accessible,
InstructionsPanel {
    private final BufferedImage img;
    private final Wizard wizard;
    private static final int MARGIN = 5;
    String[] steps = new String[0];
    private int historicWidth = Integer.MIN_VALUE;
    private boolean inSummaryPage;

    public InstructionsPanelImpl(Wizard wiz) {
        this(null, wiz);
        Font f = UIManager.getFont("Tree.font");
        if (f != null) {
            this.setFont(f);
        }
    }

    protected final Wizard getWizard() {
        return this.wizard;
    }

    public final Container getComponent() {
        return this;
    }

    public void addNotify() {
        super.addNotify();
        this.wizard.addWizardObserver(this);
    }

    public void removeNotify() {
        this.wizard.removeWizardObserver(this);
        super.removeNotify();
    }

    protected BufferedImage getImage() {
        return this.img;
    }

    public InstructionsPanelImpl(BufferedImage img, Wizard wizard) {
        if (img == null) {
            img = (BufferedImage)UIManager.get("wizard.sidebar.image");
        }
        String imgStr = System.getProperty("wizard.sidebar.image");
        if (img == null && imgStr != null) {
            ClassLoader cl = this.getClass().getClassLoader();
            URL url = cl.getResource(imgStr);
            if (url != null) {
                try {
                    img = ImageIO.read(url);
                }
                catch (IOException ioe) {
                    System.err.println("Could not load wizard image " + ioe.getMessage());
                    System.setProperty("wizard.sidebar.image", null);
                    img = null;
                }
            } else {
                System.err.println("Bad URL for wizard image " + imgStr);
                System.setProperty("wizard.sidebar.image", null);
                img = null;
            }
        }
        if (img == null) {
            try {
                img = ImageIO.read(InstructionsPanelImpl.class.getResourceAsStream("defaultWizard.png"));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        this.img = img;
        this.wizard = wizard;
    }

    public boolean isOpaque() {
        return this.img != null;
    }

    protected void paintImage(Graphics2D g, int x, int y, int w, int h) {
        BufferedImage image = this.getImage();
        if (image != null) {
            g.drawImage(image, x, y, w, h, this);
        } else {
            Color c = g.getColor();
            g.setColor(Color.WHITE);
            g.fillRect(x, y, w, h);
            g.setColor(c);
        }
    }

    public final void paintComponent(Graphics g) {
        boolean wontFit;
        Graphics2D g2d = (Graphics2D)g;
        Font f = this.getFont() != null ? this.getFont() : UIManager.getFont("controlFont");
        FontMetrics fm = g.getFontMetrics(f);
        Insets ins = this.getInsets();
        int dx = ins.left;
        int dy = ins.top;
        int w = this.getWidth() - (ins.left + ins.right);
        int hh = this.getHeight() - (ins.top + ins.bottom);
        this.paintImage(g2d, dx, dy, w, hh);
        String currentStep = this.wizard.getCurrentStep();
        if (!this.inSummaryPage) {
            this.steps = this.wizard.getAllSteps();
        }
        String[] steps = this.steps;
        if (this.inSummaryPage) {
            String summaryStep = NbBridge.getString("org/netbeans/modules/wizard/Bundle", InstructionsPanelImpl.class, "Summary");
            String[] nue = new String[steps.length + 1];
            System.arraycopy(steps, 0, nue, 0, steps.length);
            nue[nue.length - 1] = summaryStep;
            steps = nue;
        }
        int y = fm.getMaxAscent() + ins.top + 5;
        int x = ins.left + 5;
        int h = fm.getMaxAscent() + fm.getMaxDescent() + 3;
        Font boldFont = f.deriveFont(1);
        g.setFont(boldFont);
        g.drawString(NbBridge.getString("org/netbeans/modules/wizard/Bundle", InstructionsPanelImpl.class, "Steps"), x, y);
        int underlineY = ins.top + 5 + fm.getAscent() + 3;
        g.drawLine(x, underlineY, x + (this.getWidth() - (x + ins.left + 5)), underlineY);
        int bottom = this.getComponentCount() == 0 ? this.getHeight() - this.getInsets().bottom : this.getHeight() - this.getInsets().bottom - this.getComponents()[0].getPreferredSize().height;
        int first = 0;
        int stop = steps.length;
        String elipsis = NbBridge.getString("org/netbeans/modules/wizard/Bundle", InstructionsPanelImpl.class, "elipsis");
        boolean bl = wontFit = (y += h + 10) + h * steps.length > this.getHeight();
        if (wontFit) {
            int availHeight = bottom - y;
            int willFit = availHeight / h;
            int currStepIndex = Arrays.asList(steps).indexOf(currentStep);
            int rangeStart = Math.max(0, currStepIndex - willFit / 2);
            int rangeEnd = Math.min(rangeStart + willFit, steps.length);
            if (rangeStart + willFit > steps.length) {
                rangeStart = steps.length - willFit;
                rangeEnd = steps.length;
            }
            steps = (String[])steps.clone();
            if (rangeStart != 0) {
                steps[rangeStart] = elipsis;
                first = rangeStart;
            }
            if (rangeEnd != steps.length && rangeEnd > 0) {
                steps[rangeEnd - 1] = elipsis;
                stop = rangeEnd;
            }
        }
        g.setFont(this.getFont());
        g.setColor(this.getForeground());
        for (int i = first; i < stop; ++i) {
            boolean selected;
            boolean canOnlyFinish;
            boolean isUndetermined = "_#UndeterminedStep".equals(steps[i]);
            boolean bl2 = canOnlyFinish = this.wizard.getForwardNavigationMode() == 2;
            if (isUndetermined && canOnlyFinish) break;
            String curr = !elipsis.equals(steps[i]) ? (this.inSummaryPage && i == this.steps.length ? i + 1 + ". " + steps[i] : i + 1 + ". " + (isUndetermined ? NbBridge.getString("org/netbeans/modules/wizard/Bundle", class$org$netbeans$modules$wizard$InstructionsPanelImpl == null ? InstructionsPanelImpl.class$("org.netbeans.modules.wizard.InstructionsPanelImpl") : class$org$netbeans$modules$wizard$InstructionsPanelImpl, "elipsis") : (steps[i].equals(elipsis) ? elipsis : this.wizard.getStepDescription(steps[i])))) : elipsis;
            if (curr == null) continue;
            boolean bl3 = selected = steps[i].equals(currentStep) && !this.inSummaryPage || this.inSummaryPage && i == steps.length - 1;
            if (selected) {
                g.setFont(boldFont);
            }
            int width = fm.stringWidth(curr);
            while (width > this.getWidth() - (ins.left + ins.right) && curr.length() > 5) {
                curr = curr.substring(0, curr.length() - 5) + NbBridge.getString("org/netbeans/modules/wizard/Bundle", class$org$netbeans$modules$wizard$InstructionsPanelImpl == null ? InstructionsPanelImpl.class$("org.netbeans.modules.wizard.InstructionsPanelImpl") : class$org$netbeans$modules$wizard$InstructionsPanelImpl, "elipsis");
            }
            g.drawString(curr, x, y);
            if (selected) {
                g.setFont(f);
            }
            y += h;
        }
    }

    public final Dimension getPreferredSize() {
        BufferedImage img;
        Font f = this.getFont() != null ? this.getFont() : UIManager.getFont("controlFont");
        Graphics g = this.getGraphics();
        if (g == null) {
            g = new BufferedImage(1, 1, 2).getGraphics();
        }
        f = f.deriveFont(1);
        FontMetrics fm = g.getFontMetrics(f);
        Insets ins = this.getInsets();
        int h = fm.getHeight();
        String[] steps = this.wizard.getAllSteps();
        int w = Integer.MIN_VALUE;
        for (int i = 0; i < steps.length; ++i) {
            String desc = i + ". " + ("_#UndeterminedStep".equals(steps[i]) ? NbBridge.getString("org/netbeans/modules/wizard/Bundle", class$org$netbeans$modules$wizard$InstructionsPanelImpl == null ? InstructionsPanelImpl.class$("org.netbeans.modules.wizard.InstructionsPanelImpl") : class$org$netbeans$modules$wizard$InstructionsPanelImpl, "elipsis") : this.wizard.getStepDescription(steps[i]));
            if (desc == null) continue;
            w = Math.max(w, fm.stringWidth(desc) + 5);
        }
        if (Integer.MIN_VALUE == w) {
            w = 250;
        }
        if ((img = this.getImage()) != null) {
            w = Math.max(w, img.getWidth());
        }
        this.historicWidth = w = Math.max(w, this.historicWidth);
        return new Dimension(w, ins.top + ins.bottom + (h + 3) * steps.length);
    }

    public void setInSummaryPage(boolean val) {
        this.inSummaryPage = val;
        this.repaint();
    }

    public final Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void stepsChanged(Wizard wizard) {
        this.repaint();
    }

    public void navigabilityChanged(Wizard wizard) {
    }

    public void selectionChanged(Wizard wizard) {
        this.repaint();
    }

    public final void doLayout() {
        Component[] c = this.getComponents();
        Insets ins = this.getInsets();
        int y = this.getHeight() - (5 + ins.bottom);
        int x = 5 + ins.left;
        int w = this.getWidth() - (10 + ins.left + ins.right);
        if (w < 0) {
            w = 0;
        }
        for (int i = c.length - 1; i >= 0; --i) {
            Dimension d = c[i].getPreferredSize();
            c[i].setBounds(x, y - d.height, w, d.height);
            y -= d.height;
        }
    }

    public final AccessibleContext getAccessibleContext() {
        return new ACI(this);
    }

    private static final class ACI
    extends AccessibleContext {
        private final Wizard wizard;
        private final InstructionsPanelImpl panel;
        JEditorPane pane;

        public ACI(InstructionsPanelImpl pnl) {
            this.wizard = pnl.wizard;
            this.panel = pnl;
            if (pnl.getParent() instanceof Accessible) {
                this.setAccessibleParent((Accessible)((Object)pnl.getParent()));
            }
            this.setAccessibleName(NbBridge.getString("org/netbeans/modules/wizard/Bundle", class$org$netbeans$modules$wizard$InstructionsPanelImpl == null ? (class$org$netbeans$modules$wizard$InstructionsPanelImpl = InstructionsPanelImpl.class$("org.netbeans.modules.wizard.InstructionsPanelImpl")) : class$org$netbeans$modules$wizard$InstructionsPanelImpl, "ACN_InstructionsPanel"));
            this.setAccessibleDescription(NbBridge.getString("org/netbeans/modules/wizard/Bundle", class$org$netbeans$modules$wizard$InstructionsPanelImpl == null ? (class$org$netbeans$modules$wizard$InstructionsPanelImpl = InstructionsPanelImpl.class$("org.netbeans.modules.wizard.InstructionsPanelImpl")) : class$org$netbeans$modules$wizard$InstructionsPanelImpl, "ACSD_InstructionsPanel"));
        }

        public AccessibleText getAccessibleText() {
            if (this.pane == null) {
                this.pane = new JEditorPane();
                this.pane.setBounds(this.panel.getBounds());
                this.pane.getAccessibleContext().getAccessibleText();
                this.pane.setFont(this.panel.getFont());
                CellRendererPane cell = new CellRendererPane();
                cell.add(this.pane);
            }
            this.pane.setText(this.getText());
            this.pane.selectAll();
            this.pane.validate();
            return this.pane.getAccessibleContext().getAccessibleText();
        }

        public String getText() {
            StringBuffer sb = new StringBuffer();
            String[] s = this.wizard.getAllSteps();
            for (int i = 0; i < s.length; ++i) {
                sb.append(this.wizard.getStepDescription(s[i]));
                sb.append('\n');
            }
            return sb.toString();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleState[] states = new AccessibleState[]{AccessibleState.VISIBLE, AccessibleState.OPAQUE, AccessibleState.SHOWING, AccessibleState.MULTI_LINE};
            return new AccessibleStateSet(states);
        }

        public int getAccessibleIndexInParent() {
            return -1;
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int i) {
            throw new IndexOutOfBoundsException("" + i);
        }

        public Locale getLocale() throws IllegalComponentStateException {
            return Locale.getDefault();
        }
    }
}

