/*
 * Decompiled with CFR 0.152.
 */
package af.statguitoolkit.gui.datatable;

import af.statguitoolkit.gui.datatable.CellEditorChar;
import af.statguitoolkit.gui.datatable.CellEditorFactor;
import af.statguitoolkit.gui.datatable.CellEditorInt;
import af.statguitoolkit.gui.datatable.CellEditorLog;
import af.statguitoolkit.gui.datatable.CellEditorNum;
import af.statguitoolkit.gui.datatable.CellValue;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.af.jhlir.call.RChar;
import org.af.jhlir.call.RFactor;
import org.af.jhlir.call.RInteger;
import org.af.jhlir.call.RLogical;
import org.af.jhlir.call.RNumeric;
import org.af.jhlir.call.RVectorFactor;

public class CellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private DefaultCellEditor ed;

    @Override
    public Object getCellEditorValue() {
        return this.ed.getCellEditorValue();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        CellValue cv = (CellValue)value;
        RVectorFactor dfCol = cv.col;
        if (dfCol instanceof RFactor) {
            this.ed = new CellEditorFactor((RFactor)dfCol, (String)cv.val);
        } else if (dfCol instanceof RLogical) {
            this.ed = new CellEditorLog((Boolean)cv.val);
        } else if (dfCol instanceof RChar) {
            this.ed = new CellEditorChar((String)cv.val);
        } else if (dfCol instanceof RNumeric) {
            this.ed = new CellEditorNum((Double)cv.val);
        } else if (dfCol instanceof RInteger) {
            this.ed = new CellEditorInt((Integer)cv.val);
        }
        this.ed.addCellEditorListener(table);
        return this.ed.getComponent();
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() >= 2;
        }
        return true;
    }
}

