% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signed_interval_class.R
\name{signed_interval_class}
\alias{signed_interval_class}
\title{Ordered pitch-class interval represented as interval class with sign}
\usage{
signed_interval_class(x, edo = 12)
}
\arguments{
\item{x}{Single numeric value, representing an ordered pitch-class interval}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}
}
\value{
Single numeric value
}
\description{
Represents an ordered interval between two pitch-classes as a value between
\code{-edo/2} and \code{edo/2}, i.e. with an absolute value that matches its
interval class as well as a sign (plus or minus) that disambiguates
between the two OPCIs included in the interval-class. That is, C->D is
\code{2} whereas C->B-flat is \code{-2}. Exactly half the octave is represented as a
positive value.
}
\examples{
signed_interval_class(8)
signed_interval_class(6)
signed_interval_class(-6)
signed_interval_class(3*pi)
}
