% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fista_sparse}
\alias{fista_sparse}
\title{Estimate a Sparse Multiple-Subject Vector Autoregression (VAR) Model}
\usage{
fista_sparse(A, b, lambda, x_true, niter, backtrack, w = NULL,
  conv = 1e-10)
}
\arguments{
\item{A}{An N x P design matrix.}

\item{b}{An N x P outcome matrix.}

\item{lambda}{Regularization parameter.}

\item{x_true}{Numeric matrix containing the true transition matrix (if available).}

\item{niter}{Integer giving the maximum number of iterations.}

\item{backtrack}{Logical. If backtracking should be used in the FISTA algorithm.}

\item{w}{Numeric matrix containing the weights (if available).}

\item{conv}{Convergance criterion.}
}
\description{
Function for estimating multiple-subjbect Vector Autoregression models
using Fast Iterative Shrinkage-Thresholding Algorithm (FISTA; Beck and Teboulle, 2009)
}
\details{
\strong{Function Under Development}

This is a prototype function and is currently under development.
}
\examples{

theta    <- matrix(rnorm(9),3,3)
data     <- var_sim(20, theta, diag(.1,3))
datalag  <- embed(data, 2)
b        <- datalag[,1:3]
A        <- datalag[,4:6]
fista_sparse(A, b, 1, theta, niter = 1, backtrack = TRUE)


}
\references{
Fisher, Z.F., Kim, Y., and Pipiras, V. (Under Review) Penalized
Estimation and Forecasting of Multiple Subject Intensive Longitudinal Data.

Beck A. and Teboulle, M. (2009). A Fast Iterative Shrinkage-Thresholding
Algorithm for Linear Inverse Problems. SIAM J. Img. Sci. 2, 1, 183–202.
}
\keyword{lasso}
\keyword{var}
