% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update.compilr}
\alias{update.compilr}
\title{Update \code{\link{compilr}}}
\usage{
\method{update}{compilr}(object, newdata, ...)
}
\arguments{
\item{object}{A \code{\link{compilr}} class object to be updated.}

\item{newdata}{A \code{data.frame} or \code{data.table}
containing data of all variables used in the analysis.
It must include a composition and the same ID variable as the existing \code{\link{compilr}} object.}

\item{...}{generic argument, not in use.}
}
\value{
A \code{\link{compilr}} object with twelve elements.
\item{\code{BetweenComp}}{ A vector of class \code{acomp} representing one closed between-person composition
or a matrix of class \code{acomp} representing multiple closed between-person compositions each in one row.}
\item{\code{WithinComp}}{ A vector of class \code{acomp} representing one closed within-person composition
or a matrix of class \code{acomp} representing multiple closed within-person compositions each in one row.}
\item{\code{TotalComp}}{ A vector of class \code{acomp} representing one closed total composition
or a matrix of class \code{acomp} representing multiple closed total compositions each in one row.}
\item{\code{BetweenILR}}{ Isometric log ratio transform of between-person composition.}
\item{\code{WithinILR}}{ Isometric log ratio transform of within-person composition.}
\item{\code{TotalILR}}{ Isometric log ratio transform of total composition.}
\item{\code{data}}{ The user's dataset or imputed dataset if the input data contains zeros.}
\item{\code{psi}}{ A ILR matrix associated with user-defined partition structure.}
\item{\code{sbp}}{ The user-defined sequential binary partition matrix.}
\item{\code{parts}}{ Names of compositional variables.}
\item{\code{idvar}}{ Name of the variable containing IDs.}
\item{\code{total}}{ Total amount to which the compositions is closed.}
}
\description{
This method allows for updating an existing \code{\link{compilr}} object.
}
\examples{
cilr <- compilr(data = mcompd, sbp = sbp, 
                 parts = c("TST", "WAKE", "MVPA", "LPA", "SB"), idvar = "ID")

# update with new data
newdat <- mcompd[ID != 1] # excluding ID 1
cilr1 <- update(object = cilr, newdata = newdat)
}
\seealso{
\code{\link{compilr}}
}
