% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{residualDiagnostics.lme}
\alias{residualDiagnostics.lme}
\title{residualDiagnostics methods for lme objects}
\usage{
\method{residualDiagnostics}{lme}(
  object,
  ev.perc = 0.001,
  robust = FALSE,
  distr = "normal",
  standardized = TRUE,
  ...
)
}
\arguments{
\item{object}{An object with class \code{lme}.}

\item{ev.perc}{The extreme value percentile to use. Defaults to
.001.}

\item{robust}{A logical value, whether to use robust estimates or not.
Defaults to \code{FALSE}.}

\item{distr}{A character string specifying the assumed distribution.
Currently \dQuote{normal}, but future options may be supported in the
future.}

\item{standardized}{A logical value whether to use standardized pearson
residual values or not. Defaults to \code{TRUE}.}

\item{...}{Additional arguments. Not currently used.}
}
\value{
A logical (\code{is.residualDiagnostics}) or
  a residualDiagnostics object (list) for
  \code{as.residualDiagnostics} and \code{residualDiagnostics}.
}
\description{
residualDiagnostics methods for lme objects
}
\examples{

library(JWileymisc)
sleep[1,1] <- NA
m <- nlme::lme(extra ~ group, data = sleep, random = ~ 1 | ID,
  na.action = na.omit)

 residualDiagnostics(m)$Residuals

m <- nlme::lme(hp ~ mpg, data = mtcars, random = ~ 1 | cyl,
  na.action = na.omit)
residualDiagnostics(m)$Residuals

rm(m, sleep)
}
