% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supervised.R
\name{mbrda}
\alias{mbrda}
\title{Multiblock Redundancy Analysis - mbRDA}
\usage{
mbrda(X, Y, ncomp = 1, ...)
}
\arguments{
\item{X}{\code{list} of input blocks.}

\item{Y}{\code{matrix} of responses.}

\item{ncomp}{\code{integer} number of PLS components.}

\item{...}{additional arguments to ade4::mbpcaiv.}
}
\value{
\code{multiblock, mvr} object with scores, block-scores and block-loading. Relevant plotting functions: \code{\link{multiblock_plots}}
and result functions: \code{\link{multiblock_results}}.
}
\description{
This is a wrapper for the \code{ade4::mbpcaiv} function for computing mbRDA.
}
\details{
mbRDA is a multiblock formulation of Redundancy (Data) Analysis. RDA is theoretically
between PLS and GCA. Like GCA, RDA does not consider correlations within X, but like
PLS it does consider correlations within Y. RDA can also be viewed as a PCR of Y constrained to
have scores that are also linear combinations of X. If the \code{adegraphics} package is attached,
a nice overview can be plotted as \code{plot(mbr$mbpcaiv)} following the example below.
}
\examples{
# Convert data.frame with AsIs objects to list of matrices
data(potato)
potatoList <- lapply(potato, unclass)

mbr <- mbrda(potatoList[c('Chemical','Compression')], potatoList[['Sensory']], ncomp = 10)
print(mbr)
scoreplot(mbr) # Exploiting mvr object structure from pls package
}
\references{
Bougeard, S., Qannari, E.M., Lupo, C., andHanafi, M. (2011). From Multiblock Partial Least Squares to Multiblock Redundancy Analysis. A Continuum Approach. Informatica, 22(1), 11–26.
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
}
