% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.ldaPlus.R
\name{predict.ldaPlus}
\alias{predict.ldaPlus}
\title{Predict the values of a categorical variable based on a linear discriminant function}
\usage{
\method{predict}{ldaPlus}(
  object,
  newdata,
  prior = object$prior,
  dimen,
  method = c("plug-in", "predictive", "debiased"),
  betweenGroupsWeights = object$betweenGroupsWeights,
  ...
)
}
\arguments{
\item{object}{Object obtained by the \code{ldaPlus} function or by the \code{MASS::lda}.}

\item{newdata}{New dataset (without categorical variable).}

\item{prior}{Prior probabilities of class membership to be used to predict values.}

\item{dimen}{The number of dimensions/linear discriminant functions to use. Defaults to all.}

\item{method}{Possible values are \code{plug-in}, \code{predictive} and \code{debiased}.}

\item{betweenGroupsWeights}{The proportions/weights used when computing the grand/total mean from group means.}

\item{\dots}{other arguments passed to function \code{MASS::predict}.}
}
\value{
A list with the following elements:
\itemize{
\item \code{class} - Predicted values of categorical variable.
\item \code{posterior} - Posterior probabilities (the values of the Fisher's calsification linear discrimination function).
\item \code{x} - Estimated values of discriminat function(s) for each unit.
}
}
\description{
The function predicts the values of a categorical variable based on a linear discriminat function.
}
\examples{
# Use the first 20 cars to estimate the model and the rest of cars to predict
# (for each car) wheter it has a V-shape engine or a straight engine.
ldaCars <- ldaPlus(x = mtcars[1:20,c(1, 2, 4, 5, 6)], grouping = mtcars[1:20,8])
predict.ldaPlus(object = ldaCars, newdata = mtcars[20:32,c(1, 2, 4, 5, 6)])
}
\seealso{
\code{MASS::predict}
}
\author{
Aleš Žiberna
}
