% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_gaz_relations.R
\name{gaz_rest_relations_by_mrgid}
\alias{gaz_rest_relations_by_mrgid}
\title{Retrieve Gazetter Relations by MRGID}
\usage{
gaz_rest_relations_by_mrgid(
  mrgid,
  with_geometry = FALSE,
  direction = "both",
  type = "all"
)
}
\arguments{
\item{mrgid}{(integer) A valid Marine Regions Gazetteer Identifier (\link{MRGID})}

\item{with_geometry}{(logical) Add geometries to the result data frame? Default = FALSE}

\item{direction}{(character) Must be one of upper, lower, both:
\itemize{
\item \code{upper}: lists all parents of the record.
\item \code{lower}: lists all childs of the record.
\item \code{both}: lists parents and childs of the record (default)
}}

\item{type}{(character) Must be one of partof, partlypartof, adjacentto, similarto, administrativepartof, influencedby, all.}
}
\value{
A data frame with Gazetteer entries
}
\description{
Retrieve Gazetter Relations by MRGID
}
\examples{
\donttest{
gaz_rest_relations_by_mrgid(7378)
}
}
\seealso{
\href{https://marineregions.org/ontology/documentation.html}{List of types (Object Properties)}, \link{gaz_rest}, \link{MRGID}
}
