% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mr_radialegger_stan.R
\name{mr_radialegger_stan}
\alias{mr_radialegger_stan}
\title{Bayesian inverse variance weighted model with a choice of prior distributions fitted using RStan.}
\usage{
mr_radialegger_stan(
  data,
  prior = 1,
  n.chains = 3,
  n.burn = 1000,
  n.iter = 5000,
  rho = 0.5,
  seed = 12345,
  ...
)
}
\arguments{
\item{data}{A data of class \code{\link{mr_format}}.}

\item{prior}{An integer for selecting the prior distributions;
\itemize{
\item \code{1} selects a non-informative set of priors;
\item \code{2} selects weakly informative priors;
\item \code{3} selects a pseudo-horseshoe prior on the causal effect;
\item \code{4} selects joint prior of the intercept and causal effect estimate.
}}

\item{n.chains}{Numeric indicating the number of chains used in the HMC estimation in rstan, the default is \code{3} chains.}

\item{n.burn}{Numeric indicating the burn-in period of the Bayesian HMC estimation. The default is \code{1000} samples.}

\item{n.iter}{Numeric indicating the number of iterations in the Bayesian HMC estimation. The default is \code{5000} iterations.}

\item{rho}{Numeric indicating the correlation coefficient input into the joint prior distribution. The default is \code{0.5}.}

\item{seed}{Numeric indicating the random number seed. The default is \code{12345}.}

\item{...}{Additional arguments passed through to \code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}}.}
}
\value{
An object of class \code{\link{stanfit}}.
}
\description{
Bayesian inverse variance weighted model with a choice of prior distributions fitted using RStan
}
\examples{
\donttest{
if (requireNamespace("rstan", quietly = TRUE)) {
# Note we recommend setting n.burn and n.iter to larger values
radegger_fit <- mr_radialegger_stan(bmi_insulin, n.burn = 500, n.iter = 1000)
print(radegger_fit)
}
}
}
\references{
Bowden, J., et al., Improving the visualization, interpretation and analysis of two-sample summary data Mendelian randomization via the Radial plot and Radial regression. International Journal of Epidemiology, 2018. 47(4): p. 1264-1278. \doi{10.1093/ije/dyy101}.

Stan Development Team (2020). "RStan: the R interface to Stan." R package version 2.19.3, \url{https://mc-stan.org/}.
}
