% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mr_format.R
\name{mr_format}
\alias{mr_format}
\title{Organises the summary level data for use in the Bayesian MR functions}
\usage{
mr_format(rsid, xbeta, ybeta, xse, yse)
}
\arguments{
\item{rsid}{A vector of genetic variants used for analysis, if unspecified a vector is automatically generated.}

\item{xbeta}{A numeric vector of the instrument-phenotype associations.}

\item{ybeta}{A numeric vector of the instrument-outcome associations.}

\item{xse}{The standard errors of the instrument-phenotype associations \code{xbeta}.}

\item{yse}{The standard errors of the instrument-outcome associations \code{ybeta}.}
}
\value{
A formatted data frame for analysis of class \code{mr_format}.
}
\description{
Organises the summary level data for use in the Bayesian MR functions
}
\examples{
data(bmi_insulin)
dat <- mr_format(rsid = bmi_insulin[,"rsid"],
          xbeta = bmi_insulin[,"beta.exposure"],
          ybeta = bmi_insulin[,"beta.outcome"],
          xse = bmi_insulin[,"se.exposure"],
          yse = bmi_insulin[,"se.outcome"])
class(dat)

}
