% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_MC_barplot.R
\name{plot_MC_barplot}
\alias{plot_MC_barplot}
\title{Individual Barplots - Missed Cleavages}
\usage{
plot_MC_barplot(input_list, label = c("absolute", "percentage"))
}
\arguments{
\item{input_list}{A list with data frames and respective information about missed cleavages.}

\item{label}{Character string. Choose between "absolute" or "percentage". Default is "absolute".}
}
\value{
This function returns a list with a barplot for each analysis.
}
\description{
Plot number of missed cleavages for each analysis.
}
\details{
For each submitted individual analysis a detailed barplot is generated with information about the number of missed cleavages.
}
\examples{
# Load libraries
library(comprehenr)
library(tibble)

# Example data
data <- list(
 "A" = tibble::tibble(
   Analysis = c("A", "A", "A", "A", "A"),
   Missed.Cleavage = c("0", "1", "2", "3", "No R/K cleavage site"),
   mc_count = c("2513", "368", "23", "38", "10")
 ),
 "B" = tibble::tibble(
   Analysis = c("B", "B", "B", "B", "B"),
   Missed.Cleavage = c("0", "1", "2", "3", "No R/K cleavage site"),
   mc_count = c("2300", "368", "23", "38", "10")
 )
)

# Plot
plot_MC_barplot(
  input_list = data,
  label = "absolute"
)
}
\author{
Oliver Kardell
}
