\name{as.mpoly}
\alias{as.mpoly}
\title{Convert an object to an mpoly}
\usage{
as.mpoly(x)
}
\arguments{
  \item{x}{an object of class lm.}
}
\value{
the object formated as a mpoly object.
}
\description{
mpoly is the most basic function used to create objects of
class mpoly.
}
\examples{
\dontrun{
library(plyr)
library(ggplot2)
library(stringr)
n <- 101
s <- seq(-5, 5, length.out = n)

# one dimensional case
df <- data.frame(x = s)
df <- mutate(df, y = -x^2 + 2*x - 3 + rnorm(n, 0, 2))
qplot(x, y, data = df)
mod <- lm(y ~ x + I(x^2), data = df)
p <- as.mpoly(mod)
f <- as.function(p)
qplot(x, y, data = df) +
  stat_function(fun = f, colour = 'red')


# two dimensional case
df <- expand.grid(x = s, y = s)
df <- mutate(df, z = x^2 - y^2 + 2 * x*y + rnorm(n^2, 0, 3))
qplot(x, y, data = df, geom = 'raster', fill = z)
mod <- lm(z ~ x + y + I(x^2) + I(y^2) + I(x*y), data = df)
p <- as.mpoly(mod)
f <- as.function(p)
df$fit <- apply(df[,c('x','y')], 1, f)
qplot(x, y, data = df, geom = 'raster', fill = fit)
qplot(x, y, data = df, geom = 'raster', fill = z - fit) # residuals

# to do
mod <- lm(z ~ poly(x, y, degree = 2), data = df)

}
}
\author{
David Kahle \email{david.kahle@gmail.com}
}
\seealso{
\code{\link{mp}}
}

