---
---

<!-- [![CRAN_Status_Badge](http://www.r-pkg.org/badges/version/mosaic)](http://cran.r-project.org/package=mosaic) -->
[![Travis-CI Build Status](https://travis-ci.org/ProjectMOSAIC/mosaic.svg?branch=master)](https://travis-ci.org/ProjectMOSAIC/mosaic/)

## Purpose and design

The mosaic package is designed to facilitate the use of R in statistics and calculus
instruction by providing a number of functions that (a) make many common tasks fit
into a common template, and (b) simplify some tasks that would otherwise be too
complicated for beginners.

## Installation

You install from CRAN using 

```r
install.packages("mosaic")
```
or from github with

```r
devtools::install_github("ProjectMOSAIC/mosaic", build_vignettes = TRUE)
```
If you want to try out our developmental code (the beta branch), use

```r
devtools::install_github("ProjectMOSAIC/mosaic", ref="beta")
```
Updates to the master github repository are more frequent than CRAN updates.
Our beta branch is where we implement bug fixes most quickly and develop new features.
We try to keep it pretty stable, but there may be a few rough edges, missing documentation, etc. while things are in progress.  

If you discover a problem with any version of the package, be sure to let us know so that we can address it.  Post an issue on github or send email to `Rpkgs@mosaic-web.org`.

## Getting Started with mosaic

The package includes several vignettes to help you get started.  One of these 
vignettes 
([*Resources Related to the mosaic package*](https://projectmosaic.github.io/mosaic/articles/mosaic-resources.html)) includes a list of many resources, both within the
package and external to it.  That's a good place to start.

## Getting Help

Need help?  Try posting a question on Stack Overflow using the tag [r-mosaic](http://stackoverflow.com/questions/tagged/r-mosaic).


## Project MOSAIC

Project MOSAIC is a community of educators working to develop a new way to introduce mathematics, statistics, computation and modeling to students in colleges and universities.

Our goal: Provide a broader approach to quantitative studies that provides better support for work in science and technology. The focus of the project is to tie together better diverse aspects of quantitative work that students in science, technology, and engineering will need in their professional lives, but which are today usually taught in isolation, if at all.

* Modeling. The ability to create, manipulate and investigate useful and informative mathematical representations of a real-world situations.
* Statistics. The analysis of variability that draws on our ability to quantify uncertainty and to draw logical inferences from observations and experiment.
* Computation. The capacity to think algorithmically, to manage data on large scales, to visualize and interact with models, and to automate tasks for efficiency, accuracy, and reproducibility.
* Calculus. The traditional mathematical entry point for college and university students and a subject that still has the potential to provide important insights to today's students.

The name MOSAIC reflects the first letters --- M, S, C, C --- of these important components of a quantitative education. Project MOSAIC is motivated by a vision of quantitative education as a mosaic where the basic materials come together to form a complete and compelling picture.

Find out more about Project MOSAIC at [http://mosaic-web.org].

